<?php

/**
 * This is the model class for table "PrzetargFirma".
 *
 * The followings are the available columns in table 'PrzetargFirma':
 * @property double $idGrupy
 * @property double $idFirmy
 * @property double $id
 * @property int    $status
 */
class PrzetargFirma extends CActiveRecord
{
	const STATUS_REFUSED = -1;
	const STATUS_INVITED = 0;
	const STATUS_ACCEPTED = 1;
	const STATUS_OWNER = 2;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PrzetargFirma the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'PrzetargFirma';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idGrupy, idFirmy, status', 'numerical'),

			array('idGrupy, idFirmy, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'firma'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
			'grupa'=>array(self::BELONGS_TO, 'PrzetargGrupa', 'idGrupy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idGrupy'=>Yii::t('PrzetargFirma', 'idGrupy'),
			'idFirmy'=>Yii::t('PrzetargFirma', 'idFirmy'),
			'status'=>Yii::t('PrzetargFirma', 'status'),
			'id'=>Yii::t('PrzetargFirma', 'id'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('"idGrupy"', $this->idGrupy);
		$criteria->compare('"idFirmy"', $this->idFirmy);
		$criteria->compare('"status"', $this->status);
		$criteria->compare('"id"', $this->id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}